/*
 * Decompiled with CFR 0.152.
 */
package BryceMath.Numbers;

import BryceMath.Numbers.Complex;
import BryceMath.Numbers.IntB;
import BryceMath.Numbers.ModularNumber;
import BryceMath.Numbers.Rational;
import Data_Structures.ADTs.Pairable;
import Data_Structures.Structures.HashTable;
import Data_Structures.Structures.HashingClasses.AArray;
import Data_Structures.Structures.List;

public class Multinomial
extends ModularNumber<Multinomial>
implements Comparable<Multinomial> {
    private AArray<Term, Complex> data;
    public static Multinomial ZERO = new Multinomial(0L);
    public static Multinomial ONE = new Multinomial(1L);
    private static final Term CONSTANT_TERM = new Term();

    public Multinomial(long scalar) {
        this.data = new AArray(1);
        if (scalar != 0L) {
            this.data.insert(new Term(), new Complex(scalar));
        }
    }

    public Multinomial(IntB scalar) {
        this.data = new AArray(1);
        if (!scalar.eq(0)) {
            this.data.insert(new Term(), new Complex(scalar));
        }
    }

    public Multinomial(Rational scalar) {
        this.data = new AArray(1);
        if (!scalar.eq(0)) {
            this.data.insert(new Term(), new Complex(scalar));
        }
    }

    public Multinomial(Complex scalar) {
        this.data = new AArray(1);
        if (!scalar.eq(0)) {
            this.data.insert(CONSTANT_TERM, scalar);
        }
    }

    public Multinomial(String scalar_str) {
        this.data = new AArray(1);
        Complex scalar = new Complex(new Rational(scalar_str));
        if (!scalar.eq(0)) {
            this.data.insert(CONSTANT_TERM, scalar);
        }
    }

    public Multinomial(long scalar, String var) {
        this.data = new AArray(1);
        if (scalar == 0L) {
            return;
        }
        if (var.equals("i")) {
            this.data.insert(CONSTANT_TERM, new Complex(0L, scalar));
            return;
        }
        this.data.insert(new Term(var), new Complex(scalar));
    }

    public Multinomial(Rational scalar, String var) {
        this.data = new AArray(1);
        if (scalar.eq(0)) {
            return;
        }
        if (var.equals("i")) {
            this.data.insert(CONSTANT_TERM, new Complex(Rational.ZERO, scalar));
            return;
        }
        this.data.insert(new Term(var), new Complex(scalar));
    }

    public Multinomial(Complex scalar, String var) {
        this.data = new AArray();
        if (scalar.eq(0)) {
            return;
        }
        if (var.equals("i")) {
            scalar = scalar.mult(Complex.I);
            this.data.insert(CONSTANT_TERM, scalar);
            return;
        }
        this.data.insert(new Term(var), scalar);
    }

    public Multinomial(Complex scalar, String var, IntB power) {
        this.data = new AArray();
        if (scalar.eq(0)) {
            return;
        }
        if (var.equals("i")) {
            scalar = scalar.mult(Complex.power_of_i(power));
            this.data.insert(CONSTANT_TERM, scalar);
            return;
        }
        this.data.insert(new Term(var, power), scalar);
    }

    public Multinomial(Complex scalar, String var, int power) {
        this.data = new AArray();
        if (scalar.eq(0)) {
            return;
        }
        if (var.equals("i")) {
            scalar = scalar.mult(Complex.power_of_i(power));
            this.data.insert(CONSTANT_TERM, scalar);
            return;
        }
        this.data.insert(new Term(var, new IntB(power)), scalar);
    }

    public Multinomial(String var, int power) {
        this.data = new AArray();
        if (var.equals("i")) {
            Complex scalar = Complex.power_of_i(power);
            this.data.insert(CONSTANT_TERM, scalar);
            return;
        }
        this.data.insert(new Term(var, new IntB(power)), Complex.ONE);
    }

    public Multinomial(String var, IntB power) {
        this.data = new AArray();
        if (var.equals("i")) {
            Complex scalar = Complex.power_of_i(power);
            this.data.insert(CONSTANT_TERM, scalar);
            return;
        }
        this.data.insert(new Term(var, power), Complex.ONE);
    }

    private Multinomial(Complex scalar, Term term) {
        this.data = new AArray();
        if (!scalar.eq(0)) {
            this.data.insert(term, scalar);
        }
    }

    private Multinomial(AArray<Term, Complex> data_new) {
        this.data = data_new;
    }

    @Override
    Multinomial N(long n) {
        return new Multinomial(n);
    }

    @Override
    public Multinomial zero() {
        return ZERO;
    }

    @Override
    public Multinomial one() {
        return ONE;
    }

    @Override
    public Multinomial add(Multinomial input) {
        if (input.equals(ZERO)) {
            return this;
        }
        HashTable output = this.data.clone();
        AArray<Term, Complex> data2 = input.data;
        List<Term> keys = data2.getKeys();
        for (Term t : keys) {
            Complex add1 = (Complex)((AArray)output).lookup(t);
            Complex add2 = data2.lookup(t);
            if (add1 == null) {
                ((AArray)output).insert(t, add2);
                continue;
            }
            Complex result = add1.add(add2);
            if (result.eq(0)) {
                ((AArray)output).remove_key(t);
                continue;
            }
            ((AArray)output).insert(t, result);
        }
        return new Multinomial((AArray<Term, Complex>)output);
    }

    @Override
    public Multinomial sub(Multinomial input) {
        if (input.equals(ZERO)) {
            return this;
        }
        if (input.equals(this)) {
            return ZERO;
        }
        HashTable output = this.data.clone();
        AArray<Term, Complex> data2 = input.data;
        List<Term> keys = data2.getKeys();
        for (Term t : keys) {
            Complex minuend = (Complex)((AArray)output).lookup(t);
            Complex subtrahend = data2.lookup(t);
            if (minuend == null) {
                ((AArray)output).insert(t, subtrahend.neg());
                continue;
            }
            Complex result = minuend.sub(subtrahend);
            if (result.eq(0)) {
                ((AArray)output).remove_key(t);
                continue;
            }
            ((AArray)output).insert(t, result);
        }
        return new Multinomial((AArray<Term, Complex>)output);
    }

    @Override
    public Multinomial mult(Multinomial other) {
        if (other.eq(0)) {
            return ZERO;
        }
        List<Multinomial> sums = new List<Multinomial>();
        List<Term> keys = this.data.getKeys();
        for (Term k : keys) {
            Multinomial addend = other.mult(this.data.lookup(k), k);
            sums.add(addend);
        }
        return this.sum(sums);
    }

    private Multinomial mult(Complex scalar, Term input) {
        if (scalar.eq(0)) {
            return ZERO;
        }
        AArray<Term, Complex> output = new AArray<Term, Complex>(Math.max(1, this.data.size()));
        List<Term> keys = this.data.getKeys();
        for (Term t : keys) {
            Complex multiple1 = this.data.lookup(t);
            Complex result = multiple1.mult(scalar);
            output.insert(t.mult(input), result);
        }
        return new Multinomial(output);
    }

    @Override
    public Pairable<Multinomial> division(Multinomial input) {
        List<Multinomial> output = new List<Multinomial>();
        Complex scalar = input.toComplex();
        if (scalar != null) {
            output.add(this.div(scalar));
            output.add(ZERO);
            return output;
        }
        Term leading = input.getLeadingTerm();
        Multinomial quotient = ZERO;
        Multinomial remainder = this;
        Multinomial divisor = input;
        boolean found = true;
        block0: while (found) {
            found = false;
            List<Term> keys = remainder.getTerms();
            keys.sort();
            for (Term t : keys) {
                if (!t.isDivisible(leading)) continue;
                found = true;
                Term mult_term = t.div(leading);
                Complex mult_scalar = remainder.getCoef(t).div(divisor.getCoef(leading));
                Multinomial Quotient_term = new Multinomial(mult_scalar, mult_term);
                quotient = quotient.add(Quotient_term);
                Multinomial subtrahend = divisor.mult(Quotient_term);
                remainder = remainder.sub(subtrahend);
                continue block0;
            }
        }
        output.add(quotient);
        output.add(remainder);
        return output;
    }

    @Override
    private Multinomial div(Complex input) {
        if (input.eq(0)) {
            throw new Error("Division by 0 is not well defined!");
        }
        if (input.eq(1)) {
            return this;
        }
        AArray<Term, Complex> output = new AArray<Term, Complex>(this.data.getTableSize());
        List<Term> keys = this.data.getKeys();
        for (Term t : keys) {
            Complex dividend = this.data.lookup(t);
            Complex result = dividend.div(input);
            output.insert(t, result);
        }
        return new Multinomial(output);
    }

    @Override
    public Multinomial sqrt() {
        throw new Error("Not Yet implemented");
    }

    @Override
    public boolean eq(Multinomial other) {
        return this.data.equals(other.data);
    }

    public boolean isComplex() {
        return this.toComplex() != null;
    }

    public Complex toComplex() {
        int len = this.data.size();
        if (len > 1) {
            return null;
        }
        if (len == 0) {
            return Complex.ZERO;
        }
        Term key = this.data.getKeys().getFirst();
        if (key.equals(CONSTANT_TERM)) {
            return this.data.lookup(key);
        }
        return null;
    }

    @Override
    public int hashCode() {
        if (this.isInt()) {
            return this.toIntB().hashCode();
        }
        return this.data.hashCode();
    }

    @Override
    public Multinomial neg() {
        HashTable data_new = this.data.clone();
        List keys = ((AArray)data_new).getKeys();
        for (Term t : keys) {
            ((AArray)data_new).update(t, ((Complex)((AArray)data_new).lookup(t)).neg());
        }
        return new Multinomial((AArray<Term, Complex>)data_new);
    }

    private Multinomial sum(List<Multinomial> sums) {
        Multinomial output = ZERO;
        for (Multinomial e : sums) {
            output = output.add(e);
        }
        return output;
    }

    private List<Term> getTerms() {
        return this.data.getKeys();
    }

    private Complex getCoef(Term t) {
        Complex output = this.data.lookup(t);
        if (output == null) {
            return Complex.ZERO;
        }
        return output;
    }

    private Term getLeadingTerm() {
        List<Term> divisor_keys = this.data.getKeys();
        divisor_keys.sort();
        return divisor_keys.getFirst();
    }

    public Complex getLeadingCoefficient() {
        return this.getCoef(this.getLeadingTerm());
    }

    @Override
    public boolean isPositive() {
        return this.getLeadingCoefficient().isPositive();
    }

    @Override
    public boolean isNegative() {
        return this.getLeadingCoefficient().isNegative();
    }

    @Override
    public int compareTo(Multinomial other) {
        return this.toString().compareTo(other.toString());
    }

    public List<Complex> getCoefs() {
        return this.data.getValues();
    }

    public Object pow(Multinomial power) {
        throw new Error("Please Implement me!");
    }

    @Override
    public boolean isInt() {
        Complex c = this.toComplex();
        return c != null && c.isInt();
    }

    @Override
    public IntB toIntB() {
        Complex c = this.toComplex();
        if (c == null) {
            return IntB.ZERO;
        }
        return c.toIntB();
    }

    @Override
    public int toInt() {
        Complex c = this.toComplex();
        if (c == null) {
            return 0;
        }
        return c.toInt();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toSerialString() {
        return this.toString(true);
    }

    public String toString(boolean serial) {
        List<Term> keys = this.data.getKeys();
        if (keys.isEmpty()) {
            return "0";
        }
        keys.sort();
        StringBuilder output = new StringBuilder();
        for (Term t : keys) {
            Complex scalar = this.data.lookup(t);
            if (scalar.isNegative()) {
                if (!output.toString().equals("")) {
                    output.append(" - ");
                } else {
                    output.append("-");
                }
            } else if (!output.toString().equals("")) {
                output.append(" + ");
            }
            String scalar_str = t.equals(CONSTANT_TERM) ? scalar.toString() : scalar.toCoef();
            if (scalar_str.length() > 0 && scalar_str.charAt(0) == '-') {
                scalar_str = scalar_str.substring(1);
            }
            output.append(scalar_str + t.toString(serial));
        }
        return output.toString();
    }

    @Override
    public Multinomial conj() {
        HashTable data_new = this.data.clone();
        List keys = ((AArray)data_new).getKeys();
        for (Term t : keys) {
            ((AArray)data_new).update(t, ((Complex)((AArray)data_new).lookup(t)).conj());
        }
        return new Multinomial((AArray<Term, Complex>)data_new);
    }

    private static class Term
    extends AArray<String, IntB>
    implements Comparable<Term> {
        private Term() {
        }

        private Term(String var) {
            this.insert(var, IntB.ONE);
        }

        private Term(String var, IntB power) {
            this.insert(var, power);
        }

        public Term mult(Term other) {
            Term output = this.clone();
            List vars = other.getKeys();
            for (String s : vars) {
                if (s.equals("")) continue;
                IntB power_other = (IntB)other.lookup(s);
                output.increase_var(s, power_other);
            }
            return output;
        }

        private void increase_var(String var, IntB amount) {
            IntB current_power = (IntB)this.lookup(var);
            if (current_power == null) {
                this.insert(var, amount);
                return;
            }
            this.insert(var, current_power.add(amount));
        }

        @Override
        public int compareTo(Term other) {
            IntB m2;
            IntB m1 = this.getMagnitude();
            if (!m1.eq(m2 = other.getMagnitude())) {
                return m2.sub(m1).sign();
            }
            return this.toVariableNameString(false, false).compareTo(other.toVariableNameString(false, false));
        }

        @Override
        public Term clone() {
            Term output = new Term();
            List keys = this.getKeys();
            for (String s : keys) {
                output.insert(s, (IntB)this.lookup(s));
            }
            return output;
        }

        private IntB getMagnitude() {
            IntB output = IntB.ZERO;
            List powers = this.getValues();
            for (IntB i : powers) {
                output = output.add(i);
            }
            return output;
        }

        public boolean isDivisible(Term divisor) {
            List divisorVars = divisor.getKeys();
            for (String s : divisorVars) {
                IntB divisor_power = (IntB)divisor.lookup(s);
                IntB numerator_power = (IntB)this.lookup(s);
                if (divisor_power == null) {
                    divisor_power = IntB.ZERO;
                }
                if (numerator_power == null) {
                    numerator_power = IntB.ZERO;
                }
                if (s != null && numerator_power.compareTo(divisor_power) >= 0) continue;
                return false;
            }
            return true;
        }

        public Term div(Term divisor) {
            Term output = this.clone();
            List divisor_vars = divisor.getKeys();
            for (String s : divisor_vars) {
                IntB resultant_power = (IntB)this.lookup(s);
                if (resultant_power == null) {
                    resultant_power = IntB.ZERO;
                }
                if ((resultant_power = resultant_power.sub((IntB)divisor.lookup(s))).eq(0)) {
                    output.remove_key(s);
                    continue;
                }
                output.update(s, resultant_power);
            }
            return output;
        }

        public String toString(boolean serial) {
            return this.toVariableNameString(true, serial);
        }

        @Override
        public String toString() {
            return this.toVariableNameString(true, false);
        }

        private String toVariableNameString(boolean showPowers, boolean enclose_variables) {
            List keys = this.getKeys();
            if (keys.isEmpty()) {
                return "";
            }
            keys.sort();
            StringBuilder output = new StringBuilder();
            for (String s : keys) {
                IntB power = (IntB)this.lookup(s);
                if (enclose_variables && s.length() > 1) {
                    s = "'" + s + "'";
                }
                if (power.eq(1)) {
                    output.append(s);
                    continue;
                }
                if (showPowers) {
                    output.append(String.valueOf(s) + "^{" + power + "}");
                    continue;
                }
                output.append(s);
            }
            return output.toString();
        }
    }
}

